ORCA/M Asm65816 2.1.0

0001 70F4                       TITLE 'Doc register init routine'
0002 70F4
0003 70F4              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 70F4              ;	by EdAsmCvtIIGS version 1.2d7 on 5/14/91 at 7:16:40 PM
0005 70F4
0006 70F4              ;********************************************************
0007 70F4              *
0008 70F4              * Doc.exec: This routine will control the execution of the rom
0009 70F4              *           based sound diagnostics.  The test will consist of
0010 70F4              *           a ram test, register test and a limited functional
0011 70F4              *           test which will generate tones using a sawtooth
0012 70F4              *           waveform.
0013 70F4              *
0014 70F4              *     Input: e=0, m=0, x=0 ; full native
0015 70F4              *            All registers preserved.
0016 70F4              *
0017 70F4              *     Output: e=0, m=0, x=0 ; full native
0018 70F4              *             same as entry
0019 70F4              *
0020 70F4              ;********************************************************
0021 70F4              DOC_EQU  EQU   *                        ;
0022 70F4              ;
0023 70F4              ;
0024 70F4              DOC_EXEC EQU   *                        ;
0025 70F4 18                    CLC                            ;
0026 70F5 FB                    XCE                            ; native mode
0027 70F6                       LONGA ON
0028 70F6                       LONGI ON
0029 70F6 C2 30                 REP   #$30                     ; m=0, x=0
0030 70F8 8B                    PHB                            ; save data bank
0031 70F9 0B                    PHD                            ; save direct reg.
0032 70FA 3B                    TSC                            ; form a zero page area
0033 70FB 38                    SEC                            ;
0034 70FC E9 10 00              SBC   #$10                     ; 16 bytes of zero page
0035 70FF 1B                    TCS                            ;
0036 7100 1A                    INC   A                        ; point to zero page addr 0
0037 7101 48                    PHA                            ; set direct register
0038 7102 2B                    PLD                            ;
0039 7103 F4 00 00              PEA   $0000                    ; set data bank
0040 7106 AB                    PLB                            ;
0041 7107 AB                    PLB                            ;
0042 7108 20 E3 72              JSR   doc_init                 ; place doc in a known state
0043 710B              ;
0044 710B              ;**************************************************
0045 710B              *
0046 710B              * This set of tests to be integrated into
0047 710B              * Apple][GS ROM includes the following
0048 710B              * diagnostic functions related to the 
0049 710B              * Ensoniq DOC.....
0050 710B              *
0051 710B              * (0)   Address Register Test
0052 710B              * (1)   RAM data test
0053 710B              * (2)   RAM Address test
0054 710B              * (3)   Register Data Test
0055 710B              * (4)   Control Register Test
0056 710B              *
0057 710B              * Written by Ray Montagne - Oct. 30, 1986
0058 710B              *
0059 710B              ;**************************************************
0060 710B E2 30                 SEP   #$30                     ; 8 bit 'm' and 'x'
0061 710D                       LONGA OFF
0062 710D                       LONGI OFF
0063 710D              NEXT0    EQU   *
0064 710D 20 53 71              JSR   ram_data                 ; do ram data test
0065 7110 90 04                 BCC   next1                    ; if no error
0066 7112 A9 01                 LDA   #$01                     ; ram data test
0067 7114 B0 1E                 BCS   report                   ;
0068 7116              NEXT1    EQU   *
0069 7116 20 91 71              JSR   doc_ram                  ; do ram address test
0070 7119 90 04                 BCC   next2                    ; if no error
0071 711B A9 02                 LDA   #$02                     ;
0072 711D B0 15                 BCS   report                   ;
0073 711F              NEXT2    EQU   *
0074 711F 20 EF 71              JSR   reg_data                 ; do register data test
0075 7122 90 04                 BCC   next3                    ; if no error
0076 7124 A9 03                 LDA   #$03                     ;
0077 7126 B0 0C                 BCS   report                   ;
0078 7128              NEXT3    EQU   *
0079 7128 20 37 72              JSR   ctrl_reg                 ; do control register test
0080 712B 90 04                 BCC   next4                    ; if no error
0081 712D A9 04                 LDA   #$04                     ; sound glu control reg error
0082 712F B0 03                 BCS   report                   ;
0083 7131              NEXT4    EQU   *
0084 7131 20 6C 72              JSR   Doc_sound_tst            ; run the sound diagnostics
0085 7134              REPORT   EQU   *                        ;
0086 7134 E2 30                 SEP   #$30                     ; m,x 8 bits
0087 7136                       LONGA OFF
0088 7136                       LONGI OFF
0089 7136 9C 16 03              STZ   |tst_status+1            ; clear error field
0090 7139 9C 17 03              STZ   |tst_status+2            ;
0091 713C 8D 18 03              STA   |tst_status+3            ; save possible error code
0092 713F A9 0C                 LDA   #$0C                     ; save test number
0093 7141 8D 15 03              STA   |tst_status              ;    
0094 7144              ;
0095 7144              EXIT_DOC_EXEC EQU   *                   ; all done go away
0096 7144 08                    PHP                            ; save carry bit
0097 7145 20 E3 72              JSR   doc_init                 ; shut down the DOC
0098 7148 FA                    PLX                            ; carry status in x for now
0099 7149 3B                    TSC                            ; restore stack space
0100 714A 18                    CLC                            ;
0101 714B 69 10                 ADC   #$10                     ;
0102 714D 1B                    TCS                            ;
0103 714E DA                    PHX   
0104 714F 28                    PLP                            ; restore carry bit
0105 7150 2B                    PLD                            ; restore direct register
0106 7151 AB                    PLB                            ; & data bank
0107 7152 6B                    RTL                            ; >>>--- exit Doc.exec --->>>
0108 7153              ;
0109 7153              ;
0110 7153                       TITLE 'RAM data test'
0111 7153              ;**************************************************
0112 7153              *
0113 7153              * This test checks the data lines to each
0114 7153              * location in DOC ram.
0115 7153              *
0116 7153              ;**************************************************
0117 7153              RAM_DATA EQU   *
0118 7153                       LONGA OFF                      	;
0119 7153                       LONGI ON
0120 7153 C2 10                 REP   #$10                     ; 16 bit index registers
0121 7155 9C 3E C0              STZ   |sgaddrl                 ; set base address
0122 7158 9C 3F C0              STZ   |sgaddrh
0123 715B A9 40                 LDA   #%01000000               ; select ram w/o incr
0124 715D 8D 3C C0              STA   |sgcontrol
0125 7160 AD 3C C0              LDA   |sgcontrol               ; a short delay (I don't know why)
0126 7163 AD 3D C0              LDA   |sgdata
0127 7166 A0 00 00              LDY   #$0000                   ;
0128 7169              RAMDATA0 EQU   *
0129 7169 A9 01                 LDA   #$01
0130 716B 85 07                 STA   TheData                  ;Test Pattern
0131 716D A2 07 00              LDX   #$0007                   ; point top of pattern table
0132 7170              RAMDATA1 EQU   *
0133 7170 A5 07                 LDA   TheData                  ; get data pattern
0134 7172 8D 3D C0              STA   |sgdata                  ; write to sound ram
0135 7175 20 8A 71              JSR   ReadData                 ; read it back
0136 7178 C5 07                 CMP   TheData                  ; and check it
0137 717A D0 5E                 BNE   RamDatErr                ; if ram data error
0138 717C 06 07                 ASL   TheData                  ; next pattern
0139 717E D0 F0                 BNE   RamData1                 ; check all bits
0140 7180 88                    DEY                            ; next ram location
0141 7181 8C 3E C0              STY   |sgaddrl                 ; set address register
0142 7184 D0 E3                 BNE   RamData0                 ; then go test next location
0143 7186                       LONGI OFF
0144 7186 E2 10                 SEP   #$10                     ; 8 bit index registers
0145 7188 18                    CLC   
0146 7189 60                    RTS   
0147 718A              READDATA EQU   *                        ;
0148 718A AD 3D C0              LDA   |sgdata
0149 718D AD 3D C0              LDA   |sgdata
0150 7190 60                    RTS                            ;
0151 7191
0152 7191                       TITLE 'RAM address test'
0153 7191              ;**************************************************
0154 7191              *
0155 7191              * This test checks the each of the address
0156 7191              * lines to DOC ram for either shorts or 
0157 7191              * opens.  The test does not distinguish
0158 7191              * any difference between a short or open.
0159 7191              *
0160 7191              ;**************************************************
0161 7191              DOC_RAM  EQU   *
0162 7191 A9 60                 LDA   #%01100000               ; set ram w/incr
0163 7193 8D 3C C0              STA   |sgcontrol
0164 7196 AD 3C C0              LDA   |sgcontrol               ; a short delay
0165 7199 AD 3D C0              LDA   |sgdata                  ; update register data
0166 719C C2 10                 REP   #$10                     ; 16 bit 'x'
0167 719E                       LONGI ON
0168 719E A2 01 00              LDX   #$0001                   ; initial test address
0169 71A1              RAMADDR0 EQU   *
0170 71A1 20 DD 71              JSR   clrram                   ; clear all ram to zero
0171 71A4 8E 3E C0              STX   |sgaddrl                 ; set test address
0172 71A7 A9 A5                 LDA   #$A5                     ; write unique data to test addr
0173 71A9 8D 3D C0              STA   |sgdata
0174 71AC 9C 3E C0              STZ   |sgaddrl                 ; set ram base address
0175 71AF 9C 3F C0              STZ   |sgaddrh
0176 71B2 A0 00 00              LDY   #$0000                   ; address counter
0177 71B5 AD 3D C0              LDA   |sgdata                  ; clock in preset address
0178 71B8              RAMADDR1 EQU   *
0179 71B8 AD 3D C0              LDA   |sgdata                  ; read ram and check for data
0180 71BB C9 A5                 CMP   #$A5
0181 71BD F0 10                 BEQ   RamAddr2                 ; if found data
0182 71BF              RAMADDR3 EQU   *
0183 71BF 88                    DEY                            ; check all of ram
0184 71C0 D0 F6                 BNE   RamAddr1
0185 71C2 C2 20                 REP   #$20                     ; 16 bit 'm'
0186 71C4 8A                    TXA                            ; get test address
0187 71C5 0A                    ASL   a                        ; make next test addr
0188 71C6 AA                    TAX   
0189 71C7 E2 20                 SEP   #$20                     ; 8 bit 'm'
0190 71C9 90 D6                 BCC   RamAddr0                 ; loop till all lines checked
0191 71CB E2 30                 SEP   #$30                     ; 8 bit 'm' and 'x'
0192 71CD 18                    CLC                            ; return without error
0193 71CE 60                    RTS   
0194 71CF              RAMADDR2 EQU   *
0195 71CF E8                    INX                            ; adjust for auto incr
0196 71D0 E8                    INX   
0197 71D1 EC 3E C0              CPX   |sgaddrl                 ; is addr = test addr?
0198 71D4 08                    PHP   
0199 71D5 CA                    DEX                            ; but put it back
0200 71D6 CA                    DEX   
0201 71D7 28                    PLP   
0202 71D8 F0 E5                 BEQ   RamAddr3                 ; yes, ignore it
0203 71DA              RAMDATERR EQU   *                       ;
0204 71DA E2 31                 SEP   #$31                     ; 8 bit 'm' & 'x' with carry set
0205 71DC 60                    RTS   
0206 71DD                       TITLE 'Clear DOC Ram'
0207 71DD              ;**************************************************
0208 71DD              *
0209 71DD              * This routine must be called in 16 'x' native mode
0210 71DD              *
0211 71DD              ;**************************************************
0212 71DD              CLRRAM   EQU   *
0213 71DD DA                    PHX   
0214 71DE A2 00 00              LDX   #0
0215 71E1 9C 3E C0              STZ   |sgaddrl                 ; set base address
0216 71E4 9C 3F C0              STZ   |sgaddrh
0217 71E7              CLRRAM0  EQU   *
0218 71E7 9C 3D C0              STZ   |sgdata                  ; clear the ram
0219 71EA CA                    DEX   
0220 71EB D0 FA                 BNE   clrram0
0221 71ED FA                    PLX   
0222 71EE 60                    RTS   
0223 71EF                       TITLE 'Register data test'
0224 71EF              ;**************************************************
0225 71EF              *
0226 71EF              * This test checks the data lines to each
0227 71EF              * of the DOC registers.
0228 71EF              *
0229 71EF              ;**************************************************
0230 71EF                       LONGA OFF
0231 71EF                       LONGI OFF
0232 71EF              REG_DATA EQU   *
0233 71EF 9C 3E C0              STZ   |sgaddrl                 ; set base address
0234 71F2 9C 3C C0              STZ   |sgcontrol               ; select register w/o incr
0235 71F5 AD 3D C0              LDA   |sgdata
0236 71F8 A2 00                 LDX   #0                       ; init mask table pointer
0237 71FA              REGDATA0 EQU   *
0238 71FA A9 01                 LDA   #$01
0239 71FC 85 07                 STA   TheData                  ;Test Pattern
0240 71FE              REGDATA1 EQU   *
0241 71FE A5 07                 LDA   TheData                  ; get data pattern
0242 7200 3F 2F 72 FF           AND   >DataMask,x              ; bits to check
0243 7204 85 08                 STA   TestData                 ; save test data for compare
0244 7206 8D 3D C0              STA   |sgdata                  ; write to sound register
0245 7209 20 8A 71              JSR   ReadData                 ; read it back
0246 720C 3F 2F 72 FF           AND   >DataMask,x              ; mask off untestable bits
0247 7210 C5 08                 CMP   TestData                 ; and check data integrity
0248 7212 D0 19                 BNE   RegDatErr                ; if register data error
0249 7214              REGDATA2 EQU   *
0250 7214 06 07                 ASL   TheData                  ; Next pattern
0251 7216 D0 E6                 BNE   RegData1                 ; check all bits
0252 7218              REGDATA3 EQU   *
0253 7218 EE 3E C0              INC   |sgaddrl                 ; increment register address
0254 721B AD 3E C0              LDA   |sgaddrl
0255 721E C9 E0                 CMP   #$E0                     ; done all?
0256 7220 F0 09                 BEQ   RegData4                 ; yes
0257 7222 2A                    ROL   a                        ; else make mask index
0258 7223 2A                    ROL   a
0259 7224 2A                    ROL   a
0260 7225 2A                    ROL   a
0261 7226 29 07                 AND   #%00000111
0262 7228 AA                    TAX   
0263 7229 80 CF                 BRA   RegData0
0264 722B              REGDATA4 EQU   *
0265 722B 18                    CLC   
0266 722C 60                    RTS   
0267 722D              REGDATERR EQU   *
0268 722D 38                    SEC   
0269 722E 60                    RTS   
0270 722F
0271 722F
0272 722F              ;
0273 722F              ;
0274 722F              CODE_BANK EQU   RUNBANK
0275 722F                                                      ; SEG	code_bank	; code runs out of bank $FF
0276 722F              ;
0277 722F              DATAMASK EQU   *
0278 722F FF                    DC B:%11111111                 ; bits to test in addr range $00-1F
0279 7230 FF                    DC B:%11111111                 ; bits to test in addr range $20-3F
0280 7231 FF                    DC B:%11111111                 ; bits to test in addr range $40-5F
0281 7232 00                    DC B:%00000000                 ; bits to test in addr range $60-7F
0282 7233 FF                    DC B:%11111111                 ; bits to test in addr range $80-9F
0283 7234 F6                    DC B:%11110110                 ; bits to test in addr range $A0-BF
0284 7235 7F                    DC B:%01111111                 ; bits to test in addr range $C0-DF
0285 7236 00                    DC B:%00000000                 ; bits to test in addr range $E0-FF
0286 7237              ;
0287 7237                                                      ; SEG	$00
0288 7237              ;
0289 7237                       TITLE 'Control Register test'
0290 7237              ;**************************************************
0291 7237              *
0292 7237              * This test checks the operation of bits 
0293 7237              * 5 and 6 in the sound glu control register.
0294 7237              *
0295 7237              ;**************************************************
0296 7237              CTRL_REG EQU   *
0297 7237 9C 3E C0              STZ   |sgaddrl                 ; set address $0000
0298 723A 9C 3F C0              STZ   |sgaddrh
0299 723D 9C 3C C0              STZ   |sgcontrol               ; set DOC register access w/o incr
0300 7240 A9 A5                 LDA   #$A5                     ; write unique data to DOC register
0301 7242 8D 3D C0              STA   |sgdata
0302 7245 A9 40                 LDA   #%01000000               ; set DOC ram access w/o incr
0303 7247 8D 3C C0              STA   |sgcontrol
0304 724A A9 5A                 LDA   #$5A                     ; write unique data to DOC ram
0305 724C 8D 3D C0              STA   |sgdata
0306 724F 9C 3C C0              STZ   |sgcontrol               ; set DOC register access w/o incr
0307 7252 20 8A 71              JSR   ReadData                 ; read data from DOC register
0308 7255 C9 A5                 CMP   #$A5
0309 7257 D0 11                 BNE   CtrlErr                  ; if data incorrect
0310 7259 8D 3D C0              STA   |sgdata                  ; if problems, will induce ram error
0311 725C A9 40                 LDA   #%01000000               ; set DOC ram access w/o incr
0312 725E 8D 3C C0              STA   |sgcontrol
0313 7261 20 8A 71              JSR   ReadData                 ; read data from DOC ram
0314 7264 C9 5A                 CMP   #$5A
0315 7266 D0 02                 BNE   CtrlErr                  ; if data incorrect
0316 7268 18                    CLC   
0317 7269 60                    RTS   
0318 726A              CTRLERR  EQU   *
0319 726A 38                    SEC   
0320 726B 60                    RTS   
0321 726C                       TITLE 'DOC sound test'
0322 726C              ;********************************************************
0323 726C              *
0324 726C              * Doc.sound.tst: This routine load a waveform into memory and
0325 726C              *                play it in interrupt driven mode making sure
0326 726C              *                that each oscillator is able to play and
0327 726C              *                generate interrupts.
0328 726C              *
0329 726C              *     Input: e=0, m=?, x=?
0330 726C              *
0331 726C              ;********************************************************
0332 726C              DOC_SOUND_TST EQU   *                   ;
0333 726C                       LONGA OFF
0334 726C                       LONGI OFF
0335 726C 08                    PHP                            ; save m,x
0336 726D E2 30                 SEP   #$30                     ;
0337 726F 20 E3 72              JSR   doc_init                 ; set DOC to known state
0338 7272 20 63 73              JSR   make_waves               ; initialize sawtooth waveform
0339 7275 64 00                 STZ   irq_counter              ; reset interrupt counter
0340 7277 64 02                 STZ   fail_timer               ; reset failsafe timer
0341 7279 64 03                 STZ   fail_timer+1             ;
0342 727B A9 20                 LDA   #$20                     ; 32 oscillators
0343 727D 85 06                 STA   osc_busy                 ;
0344 727F                       LONGA ON                       	;
0345 727F C2 20                 REP   #$20                     ; 16 bit accumulator
0346 7281 A9 8B 73              LDA   #doc_irq                 ; set interrupt handler
0347 7284 8F 11 00 E1           STA   >irq_vector+1            ; set up vector
0348 7288 A9 73 FF              LDA   #>doc_irq                ;
0349 728B 8F 12 00 E1           STA   >irq_vector+2            ;
0350 728F                       LONGA OFF                      	;
0351 728F E2 20                 SEP   #$20                     ;
0352 7291 58                    CLI                            ; enable interrupts
0353 7292 A9 80                 LDA   #$80                     ; volume halfway
0354 7294 A2 40                 LDX   #$40                     ;
0355 7296 A0 20                 LDY   #$20                     ; all 32 oscillators
0356 7298 20 30 73              JSR   reg_init                 ;
0357 729B A9 08                 LDA   #$08                     ;
0358 729D A2 20                 LDX   #$20                     ;
0359 729F              @10      EQU   *                        ;
0360 729F 20 58 73              JSR   write_reg                ; write to the frequency register
0361 72A2 1A                    INC   A                        ; bump the 
0362 72A3 E8                    INX                            ; bump register number
0363 72A4 C6 06                 DEC   osc_busy                 ; count 32 osillators
0364 72A6 D0 F7                 BNE   @10                      ;
0365 72A8 24 06        @6       BIT   osc_busy                 ; wait for it to finish
0366 72AA D0 1B                 BNE   @5                       ;
0367 72AC A5 00                 LDA   irq_counter              ; check the interrupt count
0368 72AE C9 20                 CMP   #$20                     ; check for 32 irq osc 0-1F
0369 72B0 90 06                 BLT   @1                       ; all done! 
0370 72B2 A2 00                 LDX   #$00                     ; mark success
0371 72B4 28                    PLP                            ; mark success
0372 72B5 18                    CLC                            ;
0373 72B6 90 1B                 BCC   @2                       ; and go away
0374 72B8 A5 00        @1       LDA   irq_counter              ; point to next oscillator
0375 72BA 18                    CLC                            ;
0376 72BB 69 A0                 ADC   #doc_control             ;
0377 72BD AA                    TAX                            ;
0378 72BE A9 08                 LDA   #$08                     ; remove halt bit and enable irq
0379 72C0 20 58 73              JSR   write_reg                ;
0380 72C3 A9 FF                 LDA   #$FFFF                   ; mark oscillator busy
0381 72C5 85 06                 STA   osc_busy                 ;
0382 72C7              @5       EQU   *                        ;
0383 72C7 C2 20                 REP   #$20                     ; 16 bit accumulator
0384 72C9 C6 02                 DEC   fail_timer               ;
0385 72CB E2 20                 SEP   #$20                     ; 8 bit accumulator
0386 72CD D0 D9                 BNE   @6                       ; not exausted
0387 72CF A2 05                 LDX   #$05                     ; sound irq timeout
0388 72D1 28                    PLP                            ; set failed mark
0389 72D2 38                    SEC                            ; mark an error
0390 72D3 08           @2       PHP                            ; save status
0391 72D4                       LONGA OFF                      	;
0392 72D4 E2 20                 SEP   #$20                     ;
0393 72D6 AD 3C C0              LDA   sgcontrol                ; get control bits
0394 72D9 29 F0                 AND   #$F0                     ; mask off sys vol bits
0395 72DB 09 08                 ORA   #$08                     ; sys. vol. mid. range
0396 72DD 8D 3C C0              STA   sgcontrol                ; write it back out
0397 72E0 8A                    TXA                            ; restore possible error code
0398 72E1 28                    PLP                            ; restore m,x
0399 72E2 60                    RTS                            ; >>>--- exit doc.sound.tst --->>>
0400 72E3                       TITLE 'doc init routine'
0401 72E3              ;********************************************************
0402 72E3              *
0403 72E3              * Doc.init: This routine will set all the oscillators to a
0404 72E3              *           known state, ie; oscillators halted, volume set
0405 72E3              *           to zero, frequency registers set to zero and
0406 72E3              *           buffer pointers reset to zero.
0407 72E3              *
0408 72E3              *     Input: e=0, m=?, x=?
0409 72E3              *
0410 72E3              *     Output: e=0, m,x same as entry
0411 72E3              *             A=$01, X=$C0, Y=$00
0412 72E3              *
0413 72E3              ;********************************************************
0414 72E3              DOC_INIT EQU   *                        ;
0415 72E3 08                    PHP                            ; save m, x
0416 72E4                       LONGA OFF
0417 72E4                       LONGI OFF
0418 72E4 E2 30                 SEP   #$30                     ; m=1, x=1
0419 72E6 A9 3E                 LDA   #62                      ; enable all oscillators.
0420 72E8 A2 E1                 LDX   #$E1                     ; oscillator enable register
0421 72EA 20 58 73              JSR   write_reg                ;
0422 72ED A9 00                 LDA   #$00                     ; clear frequency registers
0423 72EF AA                    TAX                            ; frequency & volume registers
0424 72F0 A0 60                 LDY   #$60                     ; 96 registers freq. & volume
0425 72F2 20 30 73              JSR   reg_init                 ;
0426 72F5 A9 3F                 LDA   #$3F                     ; 32K buffers
0427 72F7 A2 C0                 LDX   #$C0                     ; reset size/resolution regs.
0428 72F9 A0 20                 LDY   #$20                     ; 32 registers
0429 72FB 20 30 73              JSR   reg_init                 ;
0430 72FE A9 00                 LDA   #$00                     ; osc 0-F buffer starts $0000
0431 7300 A2 80                 LDX   #$80                     ; address pointer registers
0432 7302 A0 10                 LDY   #$10                     ; 16 oscillators
0433 7304 20 30 73              JSR   reg_init                 ;
0434 7307 A9 80                 LDA   #$80                     ; osc 10-1F buffer starts $8000
0435 7309 A2 90                 LDX   #$90                     ; address pointer registers
0436 730B A0 10                 LDY   #$10                     ; 16 oscillators
0437 730D 20 30 73              JSR   reg_init                 ;
0438 7310 A9 01                 LDA   #$01                     ; control reg: no irq, halted
0439 7312 A2 A0                 LDX   #$A0                     ;
0440 7314 A0 20                 LDY   #$20                     ; 32 registers
0441 7316 20 30 73              JSR   reg_init                 ;
0442 7319              ;
0443 7319              ;              Note: The following code is required to flush
0444 7319              ;                    sound interrupts which are pending as
0445 7319              ;                    a result of enabling the oscillators.
0446 7319              ;
0447 7319 A9 04                 LDA   #doc_no_inc              ; select doc no auto incr.
0448 731B 8D 3C C0              STA   |sgcontrol               ;
0449 731E A9 E0                 LDA   #doc_irq_reg             ; point to Doc irq register
0450 7320 8D 3E C0              STA   |sgaddrl                 ;
0451 7323 A2 22                 LDX   #$22                     ; read the register 34 times
0452 7325              @10      EQU   *                        ;
0453 7325 AD 3D C0              LDA   |sgdata                  ; read for possible irq
0454 7328 CA                    DEX                            ;
0455 7329 10 FA                 BPL   @10                      ;
0456 732B 28                    PLP                            ; restore m, x
0457 732C EE 34 C0              INC   |clockctl                ; change the border color
0458 732F 60                    RTS                            ; >>>--- exit doc.init --->>>
0459 7330                       TITLE 'Doc register init routine'
0460 7330              ;********************************************************
0461 7330              *
0462 7330              * Reg.init: This routine will write a value specified by reg A
0463 7330              *           into the registers specified by the contents of
0464 7330              *           register X for a count of registers specified by
0465 7330              *           register Y.
0466 7330              *
0467 7330              *     Input: e=0, m=?, x=?
0468 7330              *            (A) = value to write to registers
0469 7330              *            (X) = first register to write to
0470 7330              *            (Y) = number of consecutive registers to write to.
0471 7330              *
0472 7330              ;********************************************************
0473 7330              REG_INIT EQU   *                        ;
0474 7330 DA                    PHX                            ; save register number
0475 7331 08                    PHP                            ; save m,x
0476 7332                       LONGA OFF
0477 7332                       LONGI OFF
0478 7332 E2 30                 SEP   #$30                     ; make all 8 bits
0479 7334 8E 3E C0              STX   |sgaddrl                 ; initialize the start reg.
0480 7337 A2 24                 LDX   #Doc_incr                ; select Doc with auto incr.
0481 7339 8E 3C C0              STX   |sgcontrol               ; sound Glu control register
0482 733C              @1       EQU   *                        ;
0483 733C 8D 3D C0              STA   sgdata                   ; write to first register
0484 733F 88                    DEY                            ; decrement register count
0485 7340 D0 FA                 BNE   @1                       ; write until count = $00
0486 7342 28                    PLP                            ; restore processor
0487 7343 FA                    PLX                            ; restore reg number
0488 7344 60                    RTS                            ; >>>--- exit Reg.init --->>>
0489 7345                       TITLE 'Read Doc register routine'
0490 7345              ;********************************************************
0491 7345              *
0492 7345              * Read.read: This routine will read any doc register specified
0493 7345              *            by the accumulator register.
0494 7345              *
0495 7345              *     Input: e=0, m=?, x=?
0496 7345              *
0497 7345              ;********************************************************
0498 7345              READ_REG EQU   *                        ;
0499 7345 08                    PHP                            ; save m, x
0500 7346 E2 30                 SEP   #$30                     ;
0501 7348 8E 3E C0              STX   |sgaddrl                 ; set up register to talk to
0502 734B A9 24                 LDA   #doc_incr                ; select the DOC
0503 734D 8D 3C C0              STA   sgcontrol                ;
0504 7350 AD 3D C0              LDA   |sgdata                  ; read the register
0505 7353 AD 3D C0              LDA   |sgdata                  ;
0506 7356 28                    PLP                            ; restore m, x
0507 7357 60                    RTS                            ; >>>--- exit Read.reg --->>>
0508 7358                       TITLE 'Write DOC register routine'
0509 7358              ;********************************************************
0510 7358              *
0511 7358              * Write.reg: This routine will write to one register in the DOC.
0512 7358              *
0513 7358              *     Input: e=0, m=?, x=?
0514 7358              *            A=data to write to register
0515 7358              *            X=register to write to
0516 7358              *
0517 7358              *     Output: e=0, m, x same as entry
0518 7358              *             A, X same as entry
0519 7358              *             Y = $00
0520 7358              *
0521 7358              ;********************************************************
0522 7358              WRITE_REG EQU   *                       ;
0523 7358                       LONGA ON                       	;
0524 7358                       LONGI ON                       	;
0525 7358 08                    PHP                            ; save m, x bits
0526 7359 C2 30                 REP   #$30                     ;
0527 735B A0 01 00              LDY   #$01                     ; one register
0528 735E 20 30 73              JSR   reg_init                 ; initialize one register
0529 7361 28                    PLP                            ; restore m, x
0530 7362 60                    RTS                            ; >>>--- exit write.reg --->>>
0531 7363                       TITLE 'Sawtooth wave maker'
0532 7363              ;********************************************************
0533 7363              *
0534 7363              * Make.waves: This routine will create a sawtooth wave pattern
0535 7363              *             throughout the DOC ram ($0000-$FFFF).
0536 7363              *             The Data pattern for the ram is as follows:
0537 7363              *             $01,$01,$02,$03......$FE,$FF.  The first $01 is
0538 7363              *             a replacement for $00 which at this stage of the
0539 7363              *             test is not allowed.
0540 7363              *
0541 7363              *     Input: e=0, m=?, x=?
0542 7363              *            A,X = don't care (preserved)
0543 7363              *      
0544 7363              ;********************************************************
0545 7363 48           MAKE_WAVES: PHA                         ; save registers
0546 7364 DA                    PHX                            ;
0547 7365 08                    PHP                            ; save m,x
0548 7366                       LONGA OFF
0549 7366                       LONGI ON
0550 7366 C2 10                 REP   #$10                     ; x=0
0551 7368 E2 20                 SEP   #$20                     ; m=1
0552 736A A2 00 00              LDX   #$0000                   ; set counter/address pointer
0553 736D 8E 3E C0              STX   |sgaddrl                 ; write to sgaddrl,sgaddrh
0554 7370 A9 64                 LDA   #ram_incr                ; DOC ram with auto incr
0555 7372 8D 3C C0              STA   sgcontrol                ;
0556 7375 A9 00                 LDA   #$00                     ; setup data pattern
0557 7377              @1       EQU   *                        ;
0558 7377 C9 00                 CMP   #$00                     ; check for zeroes
0559 7379 D0 05                 BNE   @2                       ; write it if not zero
0560 737B 1A                    INC   A                        ; make it a one
0561 737C 8D 3D C0              STA   sgdata                   ; write to the ram
0562 737F CA                    DEX                            ; decrement the count
0563 7380 8D 3D C0     @2       STA   sgdata                   ;
0564 7383 1A                    INC   A                        ; write to the ram
0565 7384 CA                    DEX                            ; decrement count
0566 7385 D0 F0                 BNE   @1                       ; write 65536 patterns
0567 7387 28                    PLP                            ; restore m,x
0568 7388 FA                    PLX                            ; restore registers
0569 7389 68                    PLA                            ;
0570 738A 60                    RTS                            ; >>>--- exit make.waves --->>>
0571 738B                       TITLE 'Doc Diags. Sound IRQ vector'
0572 738B              ;********************************************************
0573 738B              *
0574 738B              * DOC.irq: This routine will handle interrupts coming from
0575 738B              *          the DOC.  It expects to find 32 different interrupts
0576 738B              *            from the chip.
0577 738B              *
0578 738B              ;********************************************************
0579 738B                                                      ; SEG	RUNBANK
0580 738B              DOC_IRQ  EQU   *                        ;
0581 738B                                                      ; SEG	$00
0582 738B 48                    PHA                            ; save registers
0583 738C DA                    PHX                            ;
0584 738D 08                    PHP                            ; save m, x
0585 738E                       LONGA OFF                      	;
0586 738E                       LONGI OFF                      	;
0587 738E E2 30                 SEP   #$30                     ;
0588 7390 A2 E0                 LDX   #Doc_irq_reg             ; read the Doc irq register
0589 7392 20 45 73              JSR   read_reg                 ; (A)=Doc irq reg
0590 7395 0A                    ASL   A                        ;
0591 7396 B0 15                 BCS   @8                       ; not sound irq
0592 7398 4A                    LSR   A                        ;
0593 7399 4A                    LSR   A                        ; throw away low bit
0594 739A 29 1F                 AND   #$1F                     ; keep oscillator number
0595 739C              @4       EQU   *                        ;
0596 739C 64 02                 STZ   fail_timer               ; reset failsafe timer
0597 739E 64 03                 STZ   fail_timer+1             ;
0598 73A0 18                    CLC                            ;
0599 73A1 69 A0                 ADC   #doc_control             ; point to DOC control registers
0600 73A3 AA                    TAX                            ; doc register number
0601 73A4 A9 01                 LDA   #$01                     ; halt without irq.
0602 73A6 20 58 73              JSR   write_reg                ;
0603 73A9 E6 00                 INC   irq_counter              ; bump interrupt counter
0604 73AB 64 06                 STZ   osc_busy                 ; reset busy flag
0605 73AD              @8       EQU   *                        ;
0606 73AD 28                    PLP                            ; restore m, x
0607 73AE FA                    PLX                            ; restore register
0608 73AF 68                    PLA                            ;
0609 73B0 18                    CLC                            ; exit clean
0610 73B1 40                    RTI                            ; >>>--- exit Sound.irq --->>>
0611 73B2              ;
0612 73B2              ;
